require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);
SetGamePause(true);

MakeDialog
{
    CDEPanelUpgrade
    {
        name="epanelupgrade",
        x = 0,
        y = 0,
        w = 800,
        h = 600,
        
        enter_curve = "config/curves/fx_start.xml",
        exit_curve = "config/curves/fx_end.xml",
        
        Bitmap
        {
            name="panel",
            image="ui/surfaces/panel",
            x=kCenter,
            y=kCenter - 1000,

			SetStyle(CreateTextStyle(FontGame, 22, BlackColor)),
			Text
			{
				x=180,y=20,w=kMax,h=30,
				flags = kVAlignCenter + kHAlignLeft,
				label= "upgradetitle",
			},

            SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
            Text
            {
                name="text_desc",
                x=60,y=kCenter + 40,
                w=kMax-60, h=80,
                flags = kVAlignCenter + kHAlignCenter,
            },

            SetStyle({}),
            Bitmap
            {
                image = "ui/buttons/long_button_up",
                x=kCenter,
                y=kCenter + 110,

                SetStyle(CreateTextStyle(FontGame, 18, GrayColor)),
                CreateText(0,0,"upgradelater",0,0),

                SetStyle(CreatePushButtonStyle(LongButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=kCenter,
                    y=kCenter,
                    name="upgradelater",
                    default = true,
                    command=
                        function()
                            HideEndlessUpgradePanel(false);
                        end,
                    SetStyle(CreateTextStyle(FontButtons, 28, WhiteColorAlpha128)),
                    CreateText(2,2,"upgradelater",0,0),
		SetStyle(CreateTextStyle(FontButtons, 28, BlackColor)),
                    CreateText(0,0,"upgradelater",0,0),
                },
            },
        },
    }
}